# prompt-list [![NPM version](https://img.shields.io/npm/v/prompt-list.svg?style=flat)](https://www.npmjs.com/package/prompt-list) [![NPM monthly downloads](https://img.shields.io/npm/dm/prompt-list.svg?style=flat)](https://npmjs.org/package/prompt-list)  [![NPM total downloads](https://img.shields.io/npm/dt/prompt-list.svg?style=flat)](https://npmjs.org/package/prompt-list) [![Linux Build Status](https://img.shields.io/travis/enquirer/prompt-list.svg?style=flat&label=Travis)](https://travis-ci.org/enquirer/prompt-list) [![Windows Build Status](https://img.shields.io/appveyor/ci/enquirer/prompt-list.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/enquirer/prompt-list)

> List-style prompt. Can be used as a standalone prompt, or with a prompt system like [enquirer](http://enquirer.io).

Follow this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), for updates on this project and others.

![prompt-list example](https://raw.githubusercontent.com/enquirer/prompt-list/master/docs/example.gif)

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save prompt-list
```

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save prompt-list
```

## Example usage

```js
var List = require('prompt-list');
var list = new List({
  name: 'order',
  message: 'What would you like to order?',
  // choices may be defined as an array or a function that returns an array
  choices: [
    'Coke',
    'Diet Coke',
    'Cherry Coke',
    {name: 'Sprite', disabled: 'Temporarily unavailable'},
    'Water'
  ]
});

// async
list.ask(function(answer) {
  console.log(answer);
});

// promise
list.run()
  .then(function(answer) {
    console.log(answer);
  });
```

## Enquirer usage

Register the prompt as an [enquirer](http://enquirer.io) plugin:

```js
var Enquirer = require('enquirer');
var enquirer = new Enquirer();

enquirer.register('list', require('prompt-list'));
```

### Enquirer examples

Enquirer supports both declarative, inquirer-style questions, and an expressive format, using the `.question` method:

**Declarative**

```js
var questions = [
  {
    type: 'list',
    name: 'order',
    message: 'What would you like to order?',
    choices: [
      'Coke',
      'Diet Coke',
      'Cherry Coke',
      {name: 'Sprite', disabled: 'Temporarily unavailable'},
      'Water'
    ]
  }
];

enquirer.ask(questions)
  .then(function(answers) {
    console.log(answers);
  })
  .catch(function(err) {
    console.log(err);
  });
```

**Expressive**

```js
enquirer.question('order', 'What would you like to order?', {
  type: 'list',
  choices: [
    'Coke',
    'Diet Coke',
    'Cherry Coke',
    {name: 'Sprite', disabled: 'Temporarily unavailable'},
    'Water'
  ]
});

enquirer.ask(['order'])
  .then(function(answers) {
    console.log(answers);
  })
  .catch(function(err) {
    console.log(err);
  });
```

## About

### Related projects

You might also be interested in these projects:

* [enquirer-prompt](https://www.npmjs.com/package/enquirer-prompt): Base prompt module used for creating custom prompt types for Enquirer. | [homepage](https://github.com/jonschlinkert/enquirer-prompt "Base prompt module used for creating custom prompt types for Enquirer.")
* [enquirer-question](https://www.npmjs.com/package/enquirer-question): Question object, used by Enquirer and prompt plugins. | [homepage](https://github.com/enquirer/enquirer-question "Question object, used by Enquirer and prompt plugins.")
* [enquirer](https://www.npmjs.com/package/enquirer): Intuitive, plugin-based prompt system for node.js. | [homepage](http://enquirer.io "Intuitive, plugin-based prompt system for node.js.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** |  
| --- | --- |  
| 45 | [jonschlinkert](https://github.com/jonschlinkert) |  
| 6  | [doowb](https://github.com/doowb) |  
| 3  | [albizures](https://github.com/albizures) |  

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on December 28, 2017._